function [ddelta_dy,delta,dy,Delta_y_UR_bot,Delta_y_UR_top,e_bot,e_top,E_bot,E_top,...
    flag_first_call,flag_loc_seismic,flag_merged,flag_merged_unc,flag_seismic,p_inc,...
    plot_fun_1,plot_fun_2,plot_xi,xi,y_delta,y_tilde,y_tilde_unc,work] = ...
    fault_slip_dot_delta_y_cheb(a,alpha,b,cheb_terms,colors,delta,delta_c,D_center,...
    eps_reg,eta_reg,flag_cheb,flag_decouple,flag_echo,flag_eig_use,flag_first_call,...
    flag_fric,flag_lag,flag_merged,flag_merged_unc,flag_plot_diag,flag_plot_eig,...
    flag_reg,g,G,i_step,kappa,K_eff,max_iter_coupled,mu_dyn,mu_st,nu,...
    p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,tol_rel_coupled,y_delta,...
    y_plot_max_delta_1,y_plot_min_delta_1,y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_0)

% Computes the pressure derivatives of the slip patch lengths Delta_y_bot and Delta_y_top.
%   y_bound = [y_minus y_plus] are the integration boundaries for a single slip patch (either
%   top or bottom) or merged slip patches. 
%   y_bound_0 are starting values for y_bound.
%   y_tilde = [y_tilde(1) y_tilde(2) y_tilde(3) y_tilde(4)] are the slip patch boundaries.
%   y_tilde_0 are starting values for y_tilde.
% Note: it is assumed that this function is called for depletion with a monotonuously
% decreasing pressure.
%
% Uses semi-analytical integration with Chebyshev polynomials. 
%

persistent delta_store delta_bot_store delta_top_store e_bot_store e_top_store p_inc_store ...
    R_inc_store sigma_norm_eff_top_store y_delta_store y_tilde_store y_top_store % for use ...
    % in next pressure step

% Set numerical parameters:
f_damp = 0.5; % damping factor for iterative update of slip-weakening and coupled simulation

% Retrieve colors:
blue = colors(1,:);

% Compute auxiliary variables:
A = G / (2*pi*(1-nu));
N = cheb_terms; % number of terms in Chebyshev expansion (note: one element less than in paper)
small_y_delta = 1e-6;
points_type = 1; % points z_j chosen as zeros of T_n(z) where -1 < z < 1
[T,z_j] = fault_slip_cheb_matrix_T(N,N,points_type); % T = N x N matrix with ...
    % first-kind Chebyshev polynomials as columns, discretized at points z_j
% points_type = 2; % points z_j chosen as zeros of U_n(z) where -1 < z < 1
[U,~] = fault_slip_cheb_matrix_U(N,N,points_type); % U = N x N matrix with ...
    % second-kind Chebyshev polynomials as columns, discretized at points z_j
n_0 = [0,0,1./(2*(3:N))];
N_0 = diag(n_0);
n_2 = [0,0,1./(2*(1:N-2))]; % n_tilde
N_2 = diag(n_2); % N_tilde
U_1 = [zeros(N,1),U(:,1:N-1)];
U_2 = [zeros(N,2),U(:,1:N-2)]; % U_tilde

% Intialize:
Delta_y_UR_bot = 0;
Delta_y_UR_top = 0;
e_bot = 0;
e_top = 0;
e_0_bot = 0;
e_0_top = 0;
E_bot = 0;
E_top = 0;
epsilon = 0;
R_inc = zeros(1,N);
sigma_norm_eff_top = zeros(1,N);
% struct array "work":
% dR/dp:
work.dR_dp = 0;
work.dR_dp_num = 0;            
work.rms_dR_dp = 0;
% dW/dp * delta:
work.dW_dp_delta = 0;
work.dW_dp_delta_num = 0;            
work.rms_dW_dp_delta = 0;
% epsilon:
work.epsilon = 0;
% W * ddelta/dp:
work.W_ddelta_dp = 0;
work.rms_W_ddelta_dp = 0;
work.W_ddelta_dp_2 = 0;
work.rms_W_ddelta_dp_2 = 0;
% y:
work.y_top = 0;

% Set solver options:
% options = optimoptions(@fsolve,'display','off'); % overwrites default options for fsolve ...
%     % to suppress output; change to 'iter', 'iter'-detailed', 'final' or 'final-detailed' for
%     % debugging

options = optimoptions(@fsolve,'display','off','Algorithm','trust-region'); % overwrites ...
    % default options for fsolve

% options = optimoptions(@fsolve,'display','off','Algorithm','trust-region-dogleg'); % ...
%     % overwrites default options for fsolve

% options = optimoptions(@fsolve,'display','off','Algorithm','levenberg-marquardt'); % ...
%     % overwrites default options for fsolve

% options = optimoptions(@fsolve,'display','off','StepTolerance',1e-12,...
%     'FunctionTolerance',1e-12); % overwrites default options for fsolve; tighter tolerance

% options = optimoptions(@fsolve,'display','off','SpecifyObjectiveGradient',true); % ...
    % overwrites default options for fsolve. Requires user-provided Jacobian (see ...
    % fault_slip_resid_bound_cheb). Turns out not to be any faster than standard option ...
    % (with Matlab-generated finite difference Jacobian). Abandoned.

if flag_echo == 2
    fprintf('Solving for slip patch boundaries\r');
end

% A) Compute y_minus and y_plus such that conditions 1 and 2 are fulfilled, assuming there is
%    NO COUPLING between the patches:
flag_coupled = 0;
[ddelta_dy,ddelta_dy_hat_bot,ddelta_dy_hat_top,...
    delta,dy,flag_first_call,flag_loc_seismic,flag_merged,flag_merged_unc,...
    p_inc,plot_fun_1,plot_fun_2,plot_xi,xi,y_delta,y_tilde_unc] = ...
    fault_slip_delta_cheb_uncoupled(a,alpha,A,b,cheb_terms,delta,delta_c,D_center,...
    eps_reg,eta_reg,flag_echo,flag_first_call,flag_fric,flag_merged,flag_merged_unc,...
    flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,options,p_0_center,p_inc,phi,rho_f,rho_s,...
    sigma_v_0,small_y_delta,theta,T,U,y_delta,y_plot_max_delta_1,y_plot_min_delta_1,...
    y_tilde_0,z_j);

% B) Repeat the computation of y_minus and y_plus such that conditions 1 and 2 are fulfilled,
%    assuming there IS COUPLING between the patches (unless overridden by use of flag_decouple)
%    and iterate to convergence. The iteration also takes care of the slip-dependence of 
%    the fault friction in case of a slip weakening friction law (flag_fric > 1). 
if flag_merged == 0
    if (flag_fric == 1 && flag_first_call == 0) % triggers coupled simulation
        flag_coupled = 1;
    end
    if flag_decouple == 1 && (flag_fric > 1 || flag_first_call == 1)% overrides coupling to 
        % speed up simulation but leaves iteration intact to ensure proper treatment of slip 
        % weakening; the condition flag_fric > 1 has been added such that decoupling can only 
        % be activated for slip-weakening or rate and state-dependent friction
        flag_coupled = 0;
    end
    y_tilde = y_tilde_unc; % starting value for iterative improvement
end

flag_seismic = 0; % limit of aseismic slip has not yet been reached
converged = 0;
i_iter = 0;
while converged == 0 && flag_merged == 0 && flag_seismic == 0
    i_iter = i_iter + 1;
    if i_iter > max_iter_coupled
        error('\rMaximum nr. of iterations exceeded in fault_slip_delta.')
    end
    y_tilde_old = y_tilde; % to check convergence
    
    % B1) Compute y_minus and y_plus for bottom slip patch (coupled):
    y_bound_0 = [y_tilde(1) y_tilde(2)]; % starting values for bottom slip patch
    y_bound_cross = [y_tilde(3) y_tilde(4)]; % current boundaries for top slip patch
    [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound_cheb(a,alpha,b,...
        cheb_terms,ddelta_dy_hat_top,delta,delta_c,D_center,eps_reg,eta_reg,flag_coupled,...
        flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
        p_inc,phi,rho_f,rho_s,sigma_v_0,theta,T,y_bound,y_bound_cross,y_delta),y_bound_0,...
        options);
    if 0 < exitflag % solution found
        y_tilde(1) = y_bound(1);
        y_tilde(2) = y_bound(2);
    else
        if flag_fric == 1 % constant friction
            flag_merged = 1;
            if flag_echo == 2
                fprintf('Number of iterations = %2.0i\r',i_iter);
            end
        else % slip-weakening friction
            if flag_echo == 2
                fprintf('Number of iterations = %2.0i\r',i_iter);
            end
            if flag_echo > 0
                fprintf('\rFailure to converge in botom patch;')
                fprintf('\rseismic slip possibly occurs            p_inc = %7.4f MPa\r\r',...
                    p_inc/1e6);
            end
            flag_seismic = 1;
            flag_loc_seismic = 1; % location of seismic slip
            flag_lag = 1; % may overwrite pre-set value
        end
    end
    
    if flag_merged == 0 && flag_seismic == 0
        % B2) Compute y_minus and y_plus for top slip patch (coupled):
        y_bound_0 = [y_tilde(3) y_tilde(4)]; % starting values for top slip patch
        y_bound_cross = [y_tilde(1) y_tilde(2)]; % current boundaries for bottom slip patch
        [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound_cheb(a,alpha,b,...
            cheb_terms,ddelta_dy_hat_bot,delta,delta_c,D_center,eps_reg,eta_reg,flag_coupled,...
            flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
            p_inc,phi,rho_f,rho_s,sigma_v_0,theta,T,y_bound,y_bound_cross,y_delta),...
            y_bound_0,options);
        if 0 < exitflag % solution found
            y_tilde(3) = y_bound(1);
            y_tilde(4) = y_bound(2);
        else
            if flag_fric == 1 % constant friction
                flag_merged = 1;
                if flag_echo == 2
                    fprintf('Number of iterations = %2.0i\r',i_iter);
                end                
            else % slip-weakening friction
                if flag_echo == 2
                    fprintf('Number of iterations = %2.0i\r',i_iter);
                end
                if flag_echo > 0
                    fprintf('\rFailure to converge in top patch;')
                    fprintf('\rseismic slip possibly occurs            p_inc = %7.4f MPa\r\r',...
                        p_inc/1e6);
                end
                flag_seismic = 1;
                flag_loc_seismic = 2; % location of seismic slip
                flag_lag = 1; % may overwrite pre-set value
            end
        end
    end
    
    if flag_merged == 0 && flag_seismic == 0
        % Check convergence:
        check_y_tilde = (y_tilde-y_tilde_old) * (y_tilde - y_tilde_old)'; 
        if check_y_tilde/(y_tilde_old*y_tilde_old') < tol_rel_coupled
            converged = 1;
            if flag_echo == 2
                fprintf('Number of iterations = %1.0i\r',i_iter);
            end
        else
            converged = 0;
        end
    end
    
    if flag_merged == 0 && flag_seismic == 0
        % B3) Compute slip gradient for bottom slip patch (coupled):
        % B3a) Use regular Chebyshev points z_j: 
        c_n_bot = fault_slip_cheb_coeff_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,...
            eta_reg,flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,0,nu,cheb_terms,T,...
            p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_tilde(1),...
            y_tilde(2));
        if flag_coupled == 0
            ddelta_dy_bot = ( -1/(pi*A) * sqrt(1-z_j'.^2) .* U_1 * c_n_bot )';
        else
            d_n_bot = fault_slip_cheb_coeff_delta(ddelta_dy_hat_top,N,T,y_tilde(3),y_tilde(4));
            ddelta_dy_bot = ( -1/(pi*A) * sqrt(1-z_j'.^2) .* U_1 * (c_n_bot + d_n_bot) )';
        end
%         Delta_y = y_tilde_unc(2)-y_tilde_unc(1);
%         y_barbar = (y_tilde_unc(1)+y_tilde_unc(2))/2;
        Delta_y = y_tilde(2)-y_tilde(1);
        y_barbar = (y_tilde(1)+y_tilde(2))/2;
        y_bot = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points
        dy_bot = diff(y_bot);
        % B3b) Use special Chebyshev points z_j_hat for computation of cross terms:
        if flag_coupled ~= 0
            Delta_y_hat = y_tilde(4)-y_tilde(1);
            y_barbar_hat = (y_tilde(1)+y_tilde(4))/2;
            y_hat = y_barbar_hat + z_j * Delta_y_hat/2; % rescaled Chebyshev points
%             y_bot_hat = nonzeros( y_hat .* (y_tilde_unc(1) < y_hat) ...
%                 .* (y_hat < y_tilde_unc(2)) )';
            y_bot_hat = nonzeros( y_hat .* (y_tilde(1) < y_hat) ...
                .* (y_hat < y_tilde(2)) )';
            z_j_bot_hat = 2 * ((y_bot_hat-y_barbar)/Delta_y);
            M = length(z_j_bot_hat);
            [U_bot_hat,~] = fault_slip_cheb_matrix_U(N,M,6,z_j_bot_hat);
            U_1_bot_hat = [zeros(M,1),U_bot_hat(:,1:N-1)];
            ddelta_dy_hat_bot = ( -1/(pi*A) * sqrt(1-z_j_bot_hat'.^2) ...
                .* U_1_bot_hat * c_n_bot )';
        end
                
        % B4) Compute slip for bottom slip patch (coupled): 
        Delta_y = y_tilde(2)-y_tilde(1);
        delta_bot_old = delta_bot_store;
        delta_bot_new = ( -(Delta_y/2) * sqrt(1-z_j'.^2) / (pi*A) .* (U*N_0 - U_2*N_2) * ...
            c_n_bot )';
        if i_iter == 1
            delta_bot = delta_bot_new;
        else
            delta_bot = f_damp*delta_bot_old + (1-f_damp)*delta_bot_new;
        end
       
        % B5) Compute slip gradient for top slip patch (coupled):
        % B5a) Use regular Chebyshev points z_j: 
        c_n_top = fault_slip_cheb_coeff_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,...
            eta_reg,flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,0,nu,cheb_terms,T,...
            p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_tilde(3),...
            y_tilde(4));
        if flag_coupled == 0
            ddelta_dy_top = ( -1/(pi*A) * sqrt(1-z_j'.^2) .* U(:,1:end-1) * c_n_top(2:end) )';
        else
            d_n_top = fault_slip_cheb_coeff_delta(ddelta_dy_hat_bot,N,T,y_tilde(1),y_tilde(2));
            ddelta_dy_top = ( -1/(pi*A) * sqrt(1-z_j'.^2) .* U_1 * ( c_n_top + d_n_top ) )';
        end
%         Delta_y =   y_tilde_unc(4)-y_tilde_unc(3);
%         y_barbar = (y_tilde_unc(3)+y_tilde_unc(4))/2;
        Delta_y =   y_tilde(4)-y_tilde(3);
        y_barbar = (y_tilde(3)+y_tilde(4))/2;
        y_top = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points
        dy_top = diff(y_top);
        % B5b) Use special Chebyshev points z_j_hat for computation of cross terms:
        if flag_coupled ~= 0
            Delta_y_hat = y_tilde(4)-y_tilde(1);
            y_barbar_hat = (y_tilde(1)+y_tilde(4))/2;
            y_hat = y_barbar_hat + z_j * Delta_y_hat/2; % rescaled Chebyshev points
%             y_top_hat = nonzeros( y_hat .* (y_tilde_unc(3) < y_hat) ...
%                 .* (y_hat < y_tilde_unc(4)) )';
            y_top_hat = nonzeros( y_hat .* (y_tilde(3) < y_hat) ...
                .* (y_hat < y_tilde(4)) )';
            z_j_top_hat = 2 * ((y_top_hat-y_barbar)/Delta_y);
            M = length(z_j_top_hat);
            [U_top_hat,~] = fault_slip_cheb_matrix_U(N,M,6,z_j_top_hat);
            U_1_top_hat = [zeros(M,1),U_top_hat(:,1:N-1)];
            ddelta_dy_hat_top = ( -1/(pi*A) * sqrt(1-z_j_top_hat'.^2) ...
                .* U_1_top_hat * c_n_top )';
        end
        
        % B6) Compute slip for top slip patch (coupled):
        Delta_y = y_tilde(4)-y_tilde(3);
        delta_top_old = delta_top_store;
        delta_top_new = ( -(Delta_y/2) * sqrt(1-z_j'.^2) / (pi*A) .* (U*N_0 - U_2*N_2) * ...
            c_n_top )';
        if i_iter == 1
            delta_top = delta_top_new;
        else
            delta_top = f_damp*delta_top_old + (1-f_damp)*delta_top_new;
        end

        % B6-A) Compute contributions to equilibrium (for diagnostic plot in ...
        % fault_slip_patch_bounds.m):
        if flag_plot_diag == 1 && flag_fric == 2
            [~,~,~,...
                ~,~,...
                ~,~,~,...
                ~,sigma_norm_eff_top,sigma_norm_eff_comb_top,...
                ~,~,...
                ~,sigma_shear_top,sigma_shear_comb_top,...
                ~,~,y_top] = ...
                fault_slip_sigma(a,alpha,b,delta_top,delta_c,D_center,eps_reg,eta_reg,...
                flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,0,nu,p_0_center,p_inc,phi,...
                rho_f,rho_s,sigma_v_0,theta,y_top,y_top,y_top);
            % dR/dp:
            R_inc = sigma_shear_top - sigma_norm_eff_top * mu_st; % only the ...
                % incremental-pressure dependent part
            dR_dp = R_inc/p_inc; % analytical
            R_inc_store_corr = interp1(y_top_store,R_inc_store,y_top,'linear',0); ...
                % corrected for vertical shift between pressure steps
            dR_dp_num = (R_inc-R_inc_store_corr)/(p_inc-p_inc_store); % num. check
            rms_dR_dp = sqrt(trapz(y_top,dR_dp.^2)/(y_tilde(4)-y_tilde(3)));
            % dW/dp:
            dW_dp = sigma_norm_eff_top * (mu_st-mu_dyn)/(delta_c*p_inc); % analytical
            sigma_norm_eff_top_store_corr = interp1(y_top_store,sigma_norm_eff_top_store,...
                y_top,'linear',0); % corrected for vertical shift between pressure steps
            dW_dp_num = (sigma_norm_eff_top-sigma_norm_eff_top_store_corr)*...
                (mu_st-mu_dyn) /( (delta_c)*(p_inc-p_inc_store) ); % numerical check
            % dW/dp * delta:
            dW_dp_delta = dW_dp .* delta_top; % analytical
            dW_dp_delta_num = dW_dp_num .* delta_top; % numerical check
            rms_dW_dp_delta = sqrt(trapz(y_top,(dW_dp.*delta_top).^2)/(y_tilde(4)-y_tilde(3)));
            % W * ddelta/dp:
            W = sigma_norm_eff_comb_top * (mu_st-mu_dyn)/delta_c; % analytical
            delta_top_store_corr = interp1(y_top_store,delta_top_store,...
                y_top,'linear',0); % corrected for vertical shift between pressure steps
            ddelta_dp = (delta_top-delta_top_store_corr)/(p_inc-p_inc_store); % numerical
            W_ddelta_dp = W .* ddelta_dp; % numerical
            rms_W_ddelta_dp = sqrt(trapz(y_top,(W .* ddelta_dp).^2)/...
                (y_tilde(4)-y_tilde(3)));
            W_ddelta_dp_2 = W .* delta_top/p_inc; % analytical ???
            rms_W_ddelta_dp_2 = sqrt(trapz(y_top,(W .* delta_top/p_inc).^2)/...
                (y_tilde(4)-y_tilde(3)));
            % epsilon:
            help_01 = trapz(y_top,(dR_dp + dW_dp_delta).^2)/(y_tilde(4)-y_tilde(3));
            help_02 = trapz(y_top,W_ddelta_dp.^2)/(y_tilde(4)-y_tilde(3));
            epsilon = sqrt(help_01/help_02);
            % W * ddelta/dp:
            % Store for export in struct array:
            % dR/dp:
            work.dR_dp = dR_dp;
            work.dR_dp_num = dR_dp_num;
            work.rms_dR_dp = rms_dR_dp;
            % dW/dp * delta:       
            work.dW_dp_delta = dW_dp_delta; 
            work.dW_dp_delta_num = dW_dp_delta_num;            
            work.rms_dW_dp_delta = rms_dW_dp_delta;
            % epsilon:
            work.epsilon = epsilon;
            % W * ddelta/dp:       
            work.W_ddelta_dp = W_ddelta_dp; 
            work.rms_W_ddelta_dp = rms_W_ddelta_dp;
            work.W_ddelta_dp_2 = W_ddelta_dp_2;
            work.rms_W_ddelta_dp_2 = rms_W_ddelta_dp_2;
            % y:
            work.y_top = y_top;
        end
        
        % B7) Combine data for bottom and top patches (coupled):
        ddelta_dy = [0 ddelta_dy_bot ddelta_dy_top 0];
        dy = [dy_bot dy_top];
        delta = [0 delta_bot delta_top 0];
        xi = [y_bot y_top];
        y_delta_min = min(y_plot_min_delta_1,min(y_bot)-small_y_delta);
        y_delta_max = max(max(y_top)+small_y_delta,y_plot_max_delta_1);
        y_delta = [y_delta_min y_bot y_top y_delta_max];
    end
end

if (flag_eig_use == 1 || flag_plot_eig == 1) ...
        && flag_fric > 1 && flag_merged == 0 && flag_seismic == 0 && flag_first_call ~= 1
    % B8) Compute eigenvalues and eigenvectors based on linearization around current ...
    %     depletion pressure:
    if flag_lag == 1 % values from previous pressure step are used
        delta_loc = delta_store;
        p_inc_loc = p_inc_store;
        y_delta_loc = y_delta_store;
        y_tilde_loc = y_tilde_store;
    else % values from current pressure step are used
        delta_loc = delta;
        p_inc_loc = p_inc;
        y_delta_loc = y_delta;
        y_tilde_loc = y_tilde;
    end
    [Delta_y_UR_bot,Delta_y_UR_top,e_bot,e_top,e_0_bot,e_0_top,E_bot,E_top] = ...
        fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,delta_loc,delta_c,...
        D_center,epsilon,eps_reg,eta_reg,flag_cheb,flag_fric,flag_loc_seismic,...
        flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
        mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
        y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
end

if flag_eig_use == 1 ...
    && flag_fric > 1 && flag_merged == 0 && flag_seismic == 0 && flag_first_call ~= 1 
    % B9) Perform check for seismicity based on eigenvalue analysis:
    Delta_y_sim_bot = y_tilde(2) - y_tilde(1);
    Delta_y_sim_top = y_tilde(4) - y_tilde(3);
    Delta_y_eig_bot = 1/e_bot; % inverse of largest eigen value
    Delta_y_eig_top = 1/e_top;
    if Delta_y_sim_bot > Delta_y_eig_bot 
        % Repeat with improved local values (interpolated):
        Delta_y_sim_bot_store = 1/e_bot_store;
        factor = (Delta_y_eig_bot-Delta_y_sim_bot_store) / ...
            (Delta_y_sim_bot-Delta_y_sim_bot_store);
        delta_loc = delta_store + (delta_loc-delta_store) * factor;
        y_delta_loc = y_delta_store + (y_delta_loc-y_delta_store) * factor;
        p_inc_loc = p_inc_store + (p_inc_loc-p_inc_store) * factor;
        y_tilde_loc = y_tilde_store + (y_tilde_loc-y_tilde_store) * factor;
%         [e_bot,e_top,~,flag_merged] = ...
%             fault_slip_eigen_cheb_coupled(a,alpha,b,cheb_terms,colors,...
%             delta_loc,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_loc_seismic,...
%             flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
%             mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,...
%             y_delta_loc,y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
        [~,~,e_bot,e_top,e_0_bot,e_0_top,~,~] = ...
            fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,delta_loc,delta_c,...
            D_center,epsilon,eps_reg,eta_reg,flag_cheb,flag_fric,flag_loc_seismic,...
            flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
            mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,...
            y_delta_loc,y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
        p_inc = p_inc_loc; % for output
        fprintf('\rSeismic slip occurs in bottom patch     p_inc = %7.4f MPa\r\r',...
            p_inc/1e6);
        flag_seismic = 1;
        flag_loc_seismic = 1; % location of seismic slip
    end
%    if Delta_y_sim_top > Delta_y_eig_top
%      if p_inc < -16.e6 % !!! for testing
     if p_inc < -17.5122e6 % !!! maximum depletion before convergence failure (experimental)
        % Repeat with improved local values (interpolated):
        Delta_y_sim_top_store = 1/e_top_store;
        factor = (Delta_y_eig_top-Delta_y_sim_top_store) / ...
            (Delta_y_sim_top-Delta_y_sim_top_store);
        delta_loc = delta_store + (delta_loc-delta_store) * factor;
        y_delta_loc = y_delta_store + (y_delta_loc-y_delta_store) * factor;
        p_inc_loc = p_inc_store + (p_inc_loc-p_inc_store) * factor;
        y_tilde_loc = y_tilde_store + (y_tilde_loc-y_tilde_store) * factor;
%         [e_bot_c,e_top_c,~,flag_merged] = ...
%             fault_slip_eigen_cheb_coupled(a,alpha,b,cheb_terms,colors,...
%             delta_loc,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_loc_seismic,...
%             flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
%             mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
%             y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
        [~,~,e_bot,e_top,e_0_bot,e_0_top,~,~] = ...
            fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,delta_loc,delta_c,...
            D_center,epsilon,eps_reg,eta_reg,flag_cheb,flag_fric,flag_loc_seismic,...
            flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
            mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
            y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
        p_inc = p_inc_loc; % for output
        fprintf('\rSeismic slip occurs in top patch        p_inc = %7.4f MPa\r\r',...
            p_inc/1e6);
        flag_seismic = 1;
        flag_loc_seismic = 2; % location of seismic slip
    end
end

% B9) Check for merging:
if flag_merged == 0 && flag_seismic == 0
    if y_tilde(2) >= y_tilde(3)
        flag_merged = 1; % slip patches have merged
        y_tilde(2) = (y_tilde(2)+y_tilde(3))/2;
        y_tilde(3) = y_tilde(2);
    end
end

% C1) Compute y_minus and y_plus for a single, merged, patch:
if flag_merged == 1 && flag_seismic == 0
    if flag_fric == 1 && y_tilde_0(1) < 0.999 * b && y_tilde_0(4) > 0.999 * b % limits ...
            % almost reached
        y_tilde = y_tilde_0;
    else
        y_bound_0 = [y_tilde_0(1) y_tilde_0(4)]; % starting values for merged slip patches
        [y_bound,~,exitflag] = fsolve(@(y_bound) fault_slip_resid_bound_cheb(a,alpha,b,...
            cheb_terms,0,delta,delta_c,D_center,eps_reg,eta_reg,flag_coupled,...
            flag_fric,flag_merged,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,...
            p_inc,phi,rho_f,rho_s,sigma_v_0,theta,T,y_bound,0,y_delta),y_bound_0,options);
        if y_bound(1) > y_bound(2) % swap values in exceptional case that they are wrongly ...
            % ordered
            temp = y_bound(1);
            y_bound(1) = y_bound(2);
            y_bound(2) = temp;
        end
        if 0 < exitflag % solution found
            y_tilde(1) = y_bound(1);
            y_tilde(2) = (y_tilde_0(2)+y_tilde_0(3))/2; % assumes that starting value ...
            % y_tilde_0 has been defined as result from previous pressure step
            y_tilde(3) = y_tilde(2); % same comment as for y_tilde(2)
            y_tilde(4) = y_bound(2);
        else
            error('\rNo boundaries found for merged patches.');
        end
    end
    
    % C2) Compute slip gradient for merged patches:
    if flag_seismic == 0
        c_n = fault_slip_cheb_coeff_sigma(a,alpha,b,delta,delta_c,D_center,eps_reg,...
            eta_reg,flag_fric,flag_reg,g,kappa,K_eff,mu_dyn,mu_st,0,nu,cheb_terms,T,...
            p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,y_delta,y_tilde(1),...
            y_tilde(4));
        ddelta_dy_merged = ( -1/(pi*A) * sqrt(1-z_j'.^2) .* U_1 * c_n )';
        Delta_y = y_tilde(4)-y_tilde(1);
        y_barbar = (y_tilde(1)+y_tilde(4))/2;
        y_merged = y_barbar + z_j * Delta_y/2; % rescaled Chebyshev points
        dy_merged = diff(y_merged);
        
        % C3) Compute slip for merged patches:
        delta_merged = ( -(Delta_y/2) * sqrt(1-z_j'.^2) / (pi*A) .* ( U*N_0 - U*N_2) * c_n )';       

        % C4) Combine data:
        ddelta_dy = [0 ddelta_dy_merged 0];
        dy = dy_merged;
        delta = [0 delta_merged 0];
        xi = y_merged;
        y_delta_min = min(y_plot_min_delta_1,min(y_merged)-small_y_delta);
        y_delta_max = max(max(y_merged)+small_y_delta,y_plot_max_delta_1);
        y_delta = [y_delta_min y_merged y_delta_max];
    else
        ddelta_dy = 0; % dummy output
        dy = 0;        % dummy output
        delta = 0;     % dummy output
        xi = 0;        % dummy output
        y_delta = 0;   % dummy output
        y_tilde = y_tilde_0;
    end
end
y_tilde = [y_tilde(1) y_tilde(2) y_tilde(3) y_tilde(4)];

if (flag_eig_use == 1 || flag_plot_eig == 1) ...
        && flag_fric > 1 && flag_merged == 1 && flag_seismic == 0 && flag_first_call ~= 1
    % C5) Compute eigenvalues and eigenvectors based on linearization aroung current ...
    %     depletion pressure:
    if flag_lag == 1 % values from previous pressure step are used
        delta_loc = delta_store;
        p_inc_loc = p_inc_store;
        y_delta_loc = y_delta_store;
        y_tilde_loc = y_tilde_store;
    else % values from current pressure step are used
        delta_loc = delta;
        p_inc_loc = p_inc;
        y_delta_loc = y_delta;
        y_tilde_loc = y_tilde;
    end
    Delta_y_sim_merged = y_tilde(4) - y_tilde(1);
    [e_merged,~] = ...
    fault_slip_eigen_cheb_merged(a,alpha,b,cheb_terms,delta_loc,delta_c,D_center,eps_reg,...
    eta_reg,flag_fric,flag_reg,g,G,kappa,K_eff,mu_dyn,mu_st,nu,p_0_center,p_inc_loc,phi,...
    rho_f,rho_s,sigma_v_0,theta,U,y_delta_loc,y_tilde_loc,z_j);
    Delta_y_eig_merged = 1/e_merged;
    Delta_y_UR_bot = 0; % dummy
    Delta_y_UR_top = 0; % dummy
    if Delta_y_sim_merged > Delta_y_eig_merged
        fprintf('\rSeismic slip occurs in merged patches   p_inc = %7.4f MPa\r\r',...
            p_inc/1e6);
        flag_seismic = 1;
        flag_loc_seismic = 3; % location of seismic slip
    end   
end

% D) Compute eigenvalues and eigenvectors:
if flag_seismic == 1 && flag_merged == 0
% %     if flag_eig_use == 0
        if flag_lag == 1 % values from previous pressure step are used
            delta_loc = delta_store;
            p_inc_loc = p_inc_store;
            y_delta_loc = y_delta_store;
            y_tilde_loc = y_tilde_store;
        else % values from current pressure step are used
            delta_loc = delta;
            p_inc_loc = p_inc;
            y_delta_loc = y_delta;
            y_tilde_loc = y_tilde;
        end
% %     end
% %     [e_bot,e_top,~,~] = ...
% %         fault_slip_eigen_cheb_coupled(a,alpha,b,cheb_terms,colors,...
% %         delta_loc,delta_c,D_center,eps_reg,eta_reg,flag_fric,flag_loc_seismic,...
% %         flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
% %         mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
% %         y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
    [Delta_y_UR_bot,Delta_y_UR_top,e_bot,e_top,e_0_bot,e_0_top,E_bot,E_top] = ...
        fault_slip_eigen_cheb(a,alpha,b,cheb_terms,colors,delta_loc,delta_c,...
        D_center,epsilon,eps_reg,eta_reg,flag_cheb,flag_fric,flag_loc_seismic,...
        flag_plot_diag,flag_plot_eig,flag_reg,flag_seismic,g,kappa,K_eff,G,mu_dyn,...
        mu_st,nu,p_0_center,p_inc_loc,phi,rho_f,rho_s,sigma_v_0,theta,T,U,y_delta_loc,...
        y_plot_max_delta_2,y_plot_min_delta_2,y_tilde_loc,z_j);
end

% Additional diagnostic plots:
if flag_fric > 1 && flag_plot_diag == 1 && i_iter > 1
    if flag_seismic == 1
        blue = colors(1,:);
        sigma_C_top = -T*c_n_top;
        Delta_y = y_tilde(4)-y_tilde(3);
% %         zz = -sqrt(1-z_j.^2)/(pi*A); % 1 x N vector
% %         Z = diag(zz); % N x N diagonal matrix        
        zz = sqrt(1-z_j.^2)/(pi*A); % 1 x N vector
        Z = diag(zz); % N x N diagonal matrix
        a_tilde = -( (acos(z_j) - pi - z_j.*sqrt(1-z_j.^2))/(2*pi*A) )'; % N x 1 vector  
        AA_tilde = [zeros(N,1),a_tilde,zeros(N,N-2)]; 
        d_delta_dp_top = (Delta_y/2)*( AA_tilde + Z*(U*N_0-U_2*N_2) )*E_top; 
% %         d_delta_dp_top = (Delta_y/2)*Z*(U*N_0-U_2*N_2)*E_top; % induced slip rate, m/Pa
        delta_store_corr = interp1(y_delta_store,delta_store,y_delta,'linear',0); ...
            % corrected for vertical shift between pressure steps
        d_delta_dp_num = -(delta-delta_store_corr)/(p_inc-p_inc_store); % numerical approxim.
        max(abs(d_delta_dp_num)) % !!!
        
        figure
        subplot(1,4,1)
        x_plot_min = min(-sigma_C_top/1e6);
        x_plot_max = max(-sigma_C_top/1e6);
        y_plot_min = y_plot_min_delta_2;
        y_plot_max = y_plot_max_delta_2;
        hold on
        line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
        line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
        line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        plot(-sigma_C_top/1e6,y_top,'-r','LineWidth',1.5)
        hold off
        %     axis([x_plot_min x_plot_max y_plot_min y_plot_max])
        axis([-inf inf y_plot_min y_plot_max])
        box on
        xlabel('$-\sigma_C$ (MPa)','Interpreter','latex','FontSize',11)
        ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
        [t,s] = title('delta\_cheb','Simulation'); % first line: plot file locator
        t.Color = 'r';
        t.FontSize = 10;
        s.FontSize = 10;
        t.FontWeight = 'normal';
        s.FontWeight = 'normal';
        
        subplot(1,4,2)
        x_plot_min = min(ddelta_dy_top*1e3);
        x_plot_max = max(ddelta_dy_top*1e3);
        y_plot_min = y_plot_min_delta_2;
        y_plot_max = y_plot_max_delta_2;
        hold on
        line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
        line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
        line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        plot(ddelta_dy_top*1e3,y_top,'-r','LineWidth',1.5)
        hold off
        %     axis([x_plot_min x_plot_max y_plot_min y_plot_max])
        axis([-inf inf y_plot_min y_plot_max])
        box on
        xlabel('$\nabla d$ (mm/m)','Interpreter','latex','FontSize',11)
        ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
        t = title('Simulation');
        t.FontSize = 10;
        t.FontWeight = 'normal';
        
        subplot(1,4,3)
        x_plot_min = min(delta_top*1e3);
        x_plot_max = max(delta_top*1e3);
        y_plot_min = y_plot_min_delta_2;
        y_plot_max = y_plot_max_delta_2;
        hold on
        line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
        line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
        line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        plot(delta_top*1e3,y_top,'-r','LineWidth',1.5)
        hold off
        %     axis([x_plot_min x_plot_max y_plot_min y_plot_max])
        axis([-inf inf y_plot_min y_plot_max])
        box on
        xlabel('$\delta$ (mm)','Interpreter','latex','FontSize',11)
        ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
        t = title('Simulation');
        t.FontSize = 10;
        t.FontWeight = 'normal';
                
        subplot(1,4,4)
        x_plot_max_abs_1 = max(abs(d_delta_dp_top)); 
        x_plot_max_abs_2 = max(abs(d_delta_dp_num)); 
%         x_plot_min = min(d_delta_dp_num)/x_plot_max_abs_2;
%         x_plot_max = max(d_delta_dp_num)/x_plot_max_abs_2;
        x_plot_min = 0;
        x_plot_max = 1;
        y_plot_min = y_plot_min_delta_2;
        y_plot_max = y_plot_max_delta_2;
        hold on
        plot(abs(d_delta_dp_num/x_plot_max_abs_2),y_delta,'LineStyle','-','Color','r','LineWidth',1.5)
        plot(abs(d_delta_dp_top/x_plot_max_abs_1),y_top,'LineStyle','--','Color','blue','LineWidth',1.5)
%         line([x_plot_min x_plot_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
        line([0 0],[y_plot_min y_plot_max],'LineStyle','-','Color','k','LineWidth',0.5)
        line([x_plot_min x_plot_max],[-a -a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[a a],'LineStyle',':','Color','k','LineWidth',1)
        line([x_plot_min x_plot_max],[y_tilde(1) y_tilde(1)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(2) y_tilde(2)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(3) y_tilde(3)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        line([x_plot_min x_plot_max],[y_tilde(4) y_tilde(4)],'LineStyle','-','Color',blue,'LineWidth',0.5)
        hold off
        %     axis([x_plot_min x_plot_max y_plot_min y_plot_max])
        axis([-inf inf y_plot_min y_plot_max])
        box on
        xlabel('$\dot\delta / \dot\delta_{max}$ (-)','Interpreter','latex','FontSize',11)
        ylabel('$\it y$ (m)','Interpreter','latex','FontSize',11)
        [t,s] = title('Simulation','vs. Eigenvector');
        t.FontSize = 10;
        s.FontSize = 10;
        t.FontWeight = 'normal';
        s.FontWeight = 'normal';
        legend('Sim','Eig','Location','South')
    end
    
%     % Write coefficient info to screen (for diagnostics):
%     fprintf('\rCoefficient c_0 = %7.2f\r',c_n_top(1));
%     fprintf('Coefficient c_1 = %7.2f\r',c_n_top(2));
%     fprintf('Sum even coefficients / average coefficient value) = %7.2f\r',...
%         sum(c_n_top(1:2:end))/(sum(c_n_top(1:end))/N));
%     fprintf('Sum odd coefficients / average coefficient value) = %7.2f\r',...
%         sum(c_n_top(2:2:end))/(sum(c_n_top(1:end))/N));  
%     fprintf('Sum even coefficients / sum total coefficients) = %7.2f\r',...
%         sum(c_n_top(1:2:end))/sum(c_n_top(1:end)));
%     fprintf('Sum odd coefficients / sum total coefficients) = %7.2f\r\r',...
%         sum(c_n_top(2:2:end))/sum(c_n_top(1:end)));
end

if flag_fric > 1 || flag_first_call == 1
    % Save persistent values for use in eigenvalue computation in the next pressure step:
    delta_store = delta;
    delta_bot_store = delta_bot;
    delta_top_store = delta_top;
    e_bot_store = e_bot;
    e_top_store = e_top;
    p_inc_store = p_inc;
    R_inc_store = R_inc;
    sigma_norm_eff_top_store = sigma_norm_eff_top;
    y_delta_store = y_delta;
    y_tilde_store = y_tilde;
    y_top_store = y_top;
end
flag_first_call = 0;
